<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasColumn('transactions', 'purchase_mode')) {
            DB::statement(<<<'SQL'
                ALTER TABLE `transactions`
                    MODIFY COLUMN `purchase_mode`
                    ENUM('cash','consignment','terms') NOT NULL DEFAULT 'cash';
            SQL);
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('transactions', 'purchase_mode')) {
            DB::statement(<<<'SQL'
                ALTER TABLE `transactions`
                    MODIFY COLUMN `purchase_mode`
                    ENUM('cash','consignment') NOT NULL DEFAULT 'cash';
            SQL);
        }
    }
};
